<?php

namespace dokuwiki\plugin\struct\test;

use dokuwiki\plugin\struct\meta\AccessTable;
use dokuwiki\plugin\struct\meta\ConfigParser;

/**
 * Testing the CSV exports of aggregations
 *
 * @group plugin_struct
 * @group plugins
 */
class AggregationExportCSV extends StructTest
{

    public function setUp(): void
    {
        parent::setUp();

        $this->loadSchemaJSON('wikilookup', '');

        /** @var \helper_plugin_struct $helper */
        $helper = plugin_load('helper', 'struct');

        $saveDate = [
            'FirstFieldText' => 'abc def',
            'SecondFieldLongText' => "abc\ndef\n",
            'ThirdFieldWiki' => "  * hi\n  * ho",
        ];
        $access = AccessTable::getGlobalAccess('wikilookup');
        $helper->saveLookupData($access, $saveDate);
    }

    public function test_wikiColumn()
    {
        global $INPUT;
        global $INFO;

        $syntaxPrefix = ['---- struct table ----'];
        $syntaxConfig = ['schema: wikilookup', 'cols: *'];
        $syntaxPostFix = ['----'];
        $syntax = implode("\n", array_merge($syntaxPrefix, $syntaxConfig, $syntaxPostFix));
        $expectedCSV = '"FirstFieldText","SecondFieldLongText","ThirdFieldWiki"
"abc def","abc
def","  * hi
  * ho"';

        $configParser = new ConfigParser($syntaxConfig);
        $INPUT->set('hash', md5(var_export($configParser->getConfig(), true)));

        $INFO['id'] = 'unit_test';
        $ins = p_get_instructions($syntax);
        $renderedCSV = p_render('struct_csv', $ins, $info);
        $actualCSV = str_replace("\r", '', $renderedCSV);

        $this->assertEquals(trim($expectedCSV), trim($actualCSV));
    }
}
