<?php
/**
 * Unittests for the mail functionality of the publish plugin
 *
 * @group plugin_publish
 * @group plugin_publish_unittests
 * @group plugins
 * @group unittests
 * @author Michael Große <grosse@cosmocode.de>
 */
class publish_mail_unit_test extends DokuWikiTest {

    protected $pluginsEnabled = array('publish');

    /**
     * @covers helper_plugin_publish::getDifflink
     */
    function test_difflink () {
        global $ID;
        $ID = 'wiki:syntax';

        /** @var helper_plugin_publish $helper*/
        $helper = plugin_load('helper','publish');
        $actual_difflink = $helper->getDifflink('wiki:syntax','1','2');
        $expected_difflink = 'http://wiki.example.com' . DOKU_BASE . 'doku.php?id=wiki:syntax&do=diff&rev2[0]=1&rev2[1]=2&difftype=sidebyside';
        $this->assertSame($expected_difflink,$actual_difflink);
    }

    /**
     * @covers action_plugin_publish_mail::revlink
     */
    function test_apprejlink () {
        global $ID;
        $ID = 'wiki:syntax';
        $mail = new action_plugin_publish_mail;
        $actual_apprejlink = $mail->revlink('wiki:syntax','1');
        $expected_apprejlink = 'http://wiki.example.com' . DOKU_BASE . 'doku.php?id=wiki:syntax&rev=1'; //this stray dot comes from an unclean test-setup
        $this->assertSame($expected_apprejlink, $actual_apprejlink);
    }

    /**
     * @covers action_plugin_publish_mail::create_mail_body
     * @group slow
     */
    function test_change_mail_body () {
        global $ID;
        $ID = 'start';
        global $USERINFO;
        $_SERVER['REMOTE_USER'] = 'john';
        $USERINFO['name'] = 'John Smith';
        saveWikiText('start', 'start first', 'summary of save 1');
        $oldrevision = pageinfo();
        $oldrevision = $oldrevision['lastmod'];
        $this->waitForTick(true);
        global $INFO;
        $INFO = pageinfo();
        saveWikiText('start', 'start second', 'summary of save 2');
        $newrevision = pageinfo();
        $newrevision = $newrevision['lastmod'];

        $expected_mail_body =
'There is a new suggestion in your DokuWiki. Here are the details:

Date             : @DATE@
Browser          : @BROWSER@
IP-Address       : @IPADDRESS@
Hostname         : @HOSTNAME@
Previous Revision: http://wiki.example.com' . DOKU_BASE . 'doku.php?id=start&rev=' . $oldrevision . '
New Revision     : http://wiki.example.com' . DOKU_BASE . 'doku.php?id=start&rev=' . $newrevision . '
Edit Summary     : summary of save 2
User             : @USER@

http://wiki.example.com' . DOKU_BASE . 'doku.php?id=start&do=diff&rev2[0]=' . $oldrevision . '&rev2[1]=' . $newrevision . '&difftype=sidebyside


Please review the changes and approve the revision at http://wiki.example.com' . DOKU_BASE . 'doku.php?id=start&rev=' . $newrevision . ' or give feedback to @USER@.

-- '.'
This mail was generated by DokuWiki at
http://wiki.example.com' . DOKU_BASE . '
';


        $mail = new action_plugin_publish_mail;

        $actual_mail_body = $mail->create_mail_body('change');

        $this->assertSame($expected_mail_body, $actual_mail_body);

    }


    /**
     * @covers action_plugin_publish_mail::create_mail_body
     */
    function test_approve_mail_body () {
        global $ID;
        $ID = 'start';
        global $USERINFO;
        /** @var DokuWiki_Auth_Plugin $auth */
        global $auth;
        $auth->createUser('john','x','John Smith','abc@def.gh');
        $_SERVER['REMOTE_USER'] = 'john';
        $USERINFO['name'] = 'John Smith';

        global $INFO;
        $INFO = pageinfo();
        saveWikiText('start', 'start first', 'foobar');

        $_SERVER['REMOTE_USER'] = 'mike';
        $USERINFO['name'] = 'Mike Doe';
        $revision = pageinfo();
        $revision = $revision['lastmod'];

        $expected_mail_body = 'Hi John Smith!
Your suggestion for My Test Wiki at http://wiki.example.com' . DOKU_BASE . '

URL: http://wiki.example.com' . DOKU_BASE . 'doku.php?id=start&rev=' . $revision . '

is approved.

-- '.'
This mail was generated by DokuWiki at
http://wiki.example.com' . DOKU_BASE . '
';


        $mail = new action_plugin_publish_mail;

        $actual_mail_body = $mail->create_mail_body('approve');

        $this->assertSame($expected_mail_body, $actual_mail_body);

    }
}
