/*!
 * datepair.js v0.4.15 - A javascript plugin for intelligently selecting date and time ranges inspired by Google Calendar.
 * Copyright (c) 2016 Jon Thornton - http://jonthornton.github.com/Datepair.js
 * License: MIT
 */

(function(jQuery) {

	if(!jQuery) {
		return;
	}

	////////////
	// Plugin //
	////////////

	jQuery.fn.datepair = function(option) {
		var out;
		this.each(function() {
			var $this = jQuery(this);
			var data = $this.data('datepair');
			var options = typeof option === 'object' && option;

			if (!data) {
				data = new Datepair(this, options);
				$this.data('datepair', data);
			}

			if (option === 'remove') {
				out = data['remove']();
				$this.removeData('datepair', data);
			}

			if (typeof option === 'string') {
				out = data[option]();
			}
		});

		return out || this;
	};

	//////////////
	// Data API //
	//////////////

	jQuery('[data-datepair]').each(function() {
		var $this = jQuery(this);
		$this.datepair($this.data());
	});

}(window.Zepto || window.jQuery));
