<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>

<?php /* @var \dokuwiki\plugin\bez\meta\Tpl $tpl */ ?>
<div    data-type="<?php echo $tpl->get('thread')->type ?>"
        class="bez_thread
        <?php
        if ($tpl->get('thread')->state == 'opened') {
            echo 'priority_' . $tpl->get('thread')->priority;
        }
        ?>">

<h1 class="thread_box_header">

<a href="<?php echo $tpl->url('thread', 'id', $tpl->get('thread')->id) ?>">
    Proyecto: <?php echo $tpl->get('thread')->id ?>
</a>

<?php if ($tpl->get('thread')->type == 'project'): ?>
    <?php echo $tpl->getLang('project') ?>
<?php elseif (!empty($tpl->get('thread')->label_name)): ?>
    <?php echo $tpl->get('thread')->label_name ?>
<?php else: ?>
    <i style="color: #777"><?php echo $tpl->getLang('issue_type_no_specified') ?></i>
<?php endif ?>

(<?php echo $tpl->getLang('state_' . $tpl->get('thread')->state) ?>)

<?php if ($tpl->get('thread')->private == '1'): ?>
    <?php echo inlineSVG(DOKU_PLUGIN . 'bez/images/lock.svg') ?>
<?php endif ?>
</h1>

<h1 class="thread_header"><?php echo $tpl->get('thread')->title ?></h1>

<div class="timebox">
    <span>
        <strong><?php echo $tpl->getLang('open') ?>:</strong>
        <?php echo $tpl->date($tpl->get('thread')->create_date) ?>
    </span>


<?php if ($tpl->get('thread')->state == 'closed' || $tpl->get('thread')->state == 'rejected'): ?>
    <span>
        <strong><?php echo $tpl->getLang('closed') ?>:</strong>
        <?php echo $tpl->date($tpl->get('thread')->close_date) ?>
    </span>

    <span>
        <strong><?php echo $tpl->getLang('report_priority') ?>: </strong>
        <?php echo $tpl->date_diff_days($tpl->get('thread')->create_date, $tpl->get('thread')->close_date, '%a') ?>
    </span>
<?php endif ?>
</div>

<table class="data">
<tr>
    <th><?php echo $tpl->getLang('reporter') ?>:</th>
    <td>
        <?php echo $tpl->user_name($tpl->get('thread')->original_poster) ?>
    </td>

    <th><?php echo $tpl->getLang('coordinator') ?>:</th>
    <td>
        <?php if ($tpl->get('thread')->coordinator == ''): ?>
            <i style="font-weight: normal; color: #aaa"><?php echo $tpl->getLang('none') ?></i>
        <?php else: ?>
            <?php echo $tpl->user_name($tpl->get('thread')->coordinator) ?>
        <?php endif?>
    </td>
</tr>
</table>

<?php echo $tpl->get('thread')->content_html ?>
<?php if (!$tpl->get('no_actions')): ?>
    <div class="bez_buttons">

        <?php if ($tpl->param('kid') == '' &&
            $tpl->get('thread')->acl_of('state') >= BEZ_PERMISSION_CHANGE &&
            ($tpl->get('thread')->can_be_closed() ||
                $tpl->get('thread')->can_be_rejected() ||
                $tpl->get('thread')->can_be_reopened())): ?>

            <a class="bds_inline_button"
               id="plugin__bez_thread_change_state_button"
               href="<?php echo $tpl->url('thread', 'id', $tpl->get('thread')->id) ?>#k_">
                <?php if ($tpl->get('thread')->can_be_closed()): ?>
                    ↬ <?php echo $tpl->getLang('js')['close_issue' . $tpl->get('lang_suffix')] ?>
                <?php elseif ($tpl->get('thread')->can_be_rejected()): ?>
                    ↛ <?php echo $tpl->getLang('js')['reject_issue' . $tpl->get('lang_suffix')] ?>
                <?php elseif ($tpl->get('thread')->can_be_reopened()): ?>
                    ↻ <?php echo $tpl->getLang('js')['reopen_issue'. $tpl->get('lang_suffix')]  ?>
                <?php endif?>
            </a>
        <?php endif ?>

        <?php if (count($tpl->get('thread')->changable_fields(array('label_id', 'title', 'content', 'coordinator'))) > 0): ?>
            <a href="<?php echo $tpl->url('thread_report', 'action', 'edit', 'id', $tpl->get('thread')->id) ?>" class="bds_inline_button">
                ✎ <?php echo $tpl->getLang('edit') ?>
            </a>
        <?php endif ?>

        <?php if ($tpl->get('thread')->acl_of('id') >= BEZ_PERMISSION_DELETE && $tpl->get('thread')->can_be_removed()): ?>
            <a class="bds_inline_button bez_commcause_delete_prompt"
               href="<?php echo $tpl->url('thread', 'id', $tpl->get('thread')->id, 'action', 'delete');
               ?>">
                ✕ <?php echo $tpl->getLang('delete') ?>
            </a>
        <?php endif ?>

        <a class="bds_inline_button" href="
            <?php echo $tpl->mailto($tpl->user_email($tpl->get('thread')->coordinator),
                                       '#'.$tpl->get('thread')->id.' '.$tpl->get('thread')->title,
            $tpl->url('thread', 'id', $tpl->get('thread')->id)) ?>">
            ✉ <?php echo $tpl->getLang('send_mail') ?>
        </a>

        <?php if ($tpl->get('thread')->type == 'issue'): ?>
            <a href="<?php echo $tpl->url('8d', 'id', $tpl->get('thread')->id) ?>" class="bds_inline_button bds_report_button">
                ⎙ <?php echo $tpl->getLang('8d_report') ?>
            </a>
        <?php else: ?>
            <a href="<?php echo $tpl->url('kp', 'id', $tpl->get('thread')->id) ?>" class="bds_inline_button bds_report_button">
                ⎙ <?php echo $tpl->getLang('kp_report') ?>
            </a>
        <?php endif ?>
    </div>
<?php endif ?>
<?php
/* desde aqui todo el codigo es nuevo para logara la personalizacion de la herramienta

Rev
echo "valor titulo: ".$rest."<br>";
*/
$variable = $tpl->get('thread')->title;
$rest = substr($variable, 0, 20);
$variable= explode('-',$variable);
$auditado= $tpl->get('thread')->label_name;
//verificacion de nombre de cliente entre proyect (propios) y de la firma 
if($variable[1]=="")
    {
        if ($auditado==""){ 
        echo "El cliente no esta identificado";
        $auditado="No identificado";
              }
    }
else {
       if ($auditado==""){ 
        // variable no es cero y auditado es cero
         $auditado=$variable[1];
                      }
        
}

//echo "rest (INICIAL): ".$rest."<br>";

$coordinador= $tpl->get('thread')->coordinator;
$codigo = $tpl->get('thread')->id;
$misprogramas="proyectos:auditorias:programas_auditoria:";
//echo "variable2: ".$variable[1]."CLIENTE SISTEMA2: ".$auditado."<br>";
//creacion de carpetas
//se comprueba la disponibilidad hasta el final el if se cierra hasta el final
//echo "destino: ".$micarpeta."<br>";


if ($rest=="Revisoría fiscal (A"){
    $proyecto="A";
    $rest= "REVISORÍA FISCAL (Nuevo)";
    $micarpeta="data/pages/proyectos/control/".$codigo;
 //   echo "rest (a): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
elseif
($rest=="Revisoría fiscal (B"){
//notas B -NIAS -CLIENTE RECURRENTE 
    $proyecto="B";
    $rest= "REVISORÍA FISCAL (Recurrente)";
    $micarpeta="data/pages/proyectos/control/".$codigo."/recurrente";
  //  echo "rest (b): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
}
    
//notas C - NAGAS -CLIENTE NUEVO
 elseif ($rest=="Revisoría fiscal (C"){
    $proyecto="C";
    $rest= "REVISORÍA FISCAL (Nuevo)";
    $micarpeta="data/pages/proyectos/control/".$codigo;
   // echo "rest (c): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
//notas D - NAGAS CLIENTE RECURRENTE
 elseif ($rest=="Revisoría fiscal (D"){
    $proyecto="D";
    $rest= "REVISORÍA FISCAL (Recurrente)";
    $micarpeta="data/pages/proyectos/control/".$codigo."/recurrente";
  //  echo "rest (d): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
   
//notas E PEI NIAS -CLIENTE NUEVO
 elseif ($rest=="Revisoría fiscal (E"){
    $proyecto="E";
    $rest= "REVISORÍA FISCAL /PEI -(Nuevo)";
    $micarpeta="data/pages/proyectos/control/".$codigo."/pei";

    }
    
//notas F -NIAS -CLIENTE RECURRENTE 
 elseif ($rest=="Revisoría fiscal (F"){
    $proyecto="F";
    $rest= "REVISORÍA FISCAL /PEI (Recurrente)";
    $micarpeta="data/pages/proyectos/control/".$codigo."/pei/recurrente";
  //  echo "rest (F): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
 elseif ($rest=="Revisoría fiscal (G"){
    $proyecto="G";
    $rest= "REVISORÍA FISCAL /PEI (Recurrente)";
    $micarpeta="data/pages/proyectos/control/".$codigo."/pei";
   // echo "rest (G): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
 elseif ($rest=="Revisoría fiscal (H"){
    $proyecto="H";
    $rest= "REVISORÍA FISCAL /PEI (Recurrente)";
    $micarpeta="data/pages/proyectos/control/".$codigo."/pei/recurrente";
   // echo "rest (H): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
elseif ($rest=="Outsourcing contable"){
    $proyecto="I";
    $rest= "OUTSOURCING CONTABLE";
    $micarpeta="data/pages/proyectos/control/".$codigo."/outsourcing";
   //  echo "rest (I): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
 elseif ($rest=="Asesoría contable  "){
    $proyecto="J";
    $rest= "ASESORÍA CONTABLE";
    $micarpeta="data/pages/proyectos/control/".$codigo."/asesoria";
  //  echo "rest (J): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
 elseif ($rest=="Otros proyectos     "){
    $proyecto="K";
    $rest= "PROYECTO";
    $micarpeta="data/pages/proyectos/control/".$codigo."/otros";
  //   echo "rest (K): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
   
 elseif ($rest=="Reporte de gestión "){
    $proyecto="L";
    $rest= "REPORTE DE GESTIÓN";
    $micarpeta="data/pages/proyectos/control/".$codigo."/reporte";
   // echo "rest (L): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
 elseif ($rest=="Outsourcing         "){
    $proyecto="M";
    $rest= "OUTSOURCING /PEI";
    $micarpeta="data/pages/proyectos/control/".$codigo."/outsourcing/pei";
 //   echo "rest (M): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }
    
elseif ($rest=="Asesoría           "){
    $proyecto="N";
    $rest= "ASESORÍA CONTABLE /PEI";
    $micarpeta="data/pages/proyectos/control/".$codigo."/asesoria/pei";
  //  echo "rest (N): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }

else {
    $proyecto="X";
 //   echo "rest (N): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";
    }

// echo "rest (FIN): ".$rest."proyecto: ".$proyecto." dir: ".$micarpeta."<br>";   


if (!file_exists($micarpeta)) {
/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
<?php
if ($a > $b) {
    echo "a is bigger than b";
} elseif ($a == $b) {
    echo "a is equal to b";
} else {
    echo "a is smaller than b";
}
//notas A NIAS -CLIENTE NUEVO */
$parte1="[[{:boton2:titulo7.png}es:bez:thread:id:".$codigo."|Regresar]]

";


$parte2 ="
<WRAP lef round info 45%>

**ID:** ".$codigo."


**CLIENTE:** ".$auditado."


**COORDINADOR:**  ".$coordinador."


**OPERACIÓN:**  ".$rest."


</WRAP>


";

$parte3 = "

{{filelisting>...:}}

</WRAP>


----


~~CLOSETOC~~

~~DISCUSSION~~";

$programas1 ="

<WRAP center round box 100%>


=== 10. CONSOLIDADO DE REGISTROS DE PROGRAMAS DE AUDITORÍA ===



";
$programas2= "

== PROGRAMA GENERAL DE AUDITORÍA ==

{{dolist>".$misprogramas."general:".$codigo."?registro=ID&status=DONE}}

== EFECTIVO Y EQUIVALENTES AL EFECTIVO ==

{{dolist>".$misprogramas."28_efectivo:".$codigo."?registro=ID&status=DONE}}

== INVERSIONES PERMANENTES ==

{{dolist>".$misprogramas."29_inversiones:".$codigo."?registro=ID&status=DONE}}

== CUENTAS POR COBRAR ==

{{dolist>".$misprogramas."31_cuentas_cobrar:".$codigo."?registro=ID&status=DONE}}

== ACTIVOS INTANGIBLES ==

{{dolist>".$misprogramas."32_activos_intangibles:".$codigo."?registro=ID&status=DONE}}


== GASTOS PAGADOS POR ANTICIPADO ==

{{dolist>".$misprogramas."33_gastos_anticipado:".$codigo."?registro=ID&status=DONE}}

== PASIVOS, PROVISIONES Y CONTINGENCIAS ==

{{dolist>".$misprogramas."34_pasivos_provisiones:".$codigo."?registro=ID&status=DONE}}

== REVISIÓN ICA BIMESTRAL ==

{{dolist>".$misprogramas."47_ica_bimestral:".$codigo."?registro=ID&status=DONE}}

== REVISIÓN IVA BIMESTRAL ==

{{dolist>".$misprogramas."48_iva_bimestral:".$codigo."?registro=ID&status=DONE}}

== REVISIÓN RETENCIÓN EN LA FUENTE ==

{{dolist>".$misprogramas."49_rete_fte:".$codigo."?registro=ID&status=DONE}}

== REVISIÓN RTE ICA BIMESTRAL ==

{{dolist>".$misprogramas."50_rte_ica:".$codigo."?registro=ID&status=DONE}}

== REVISIÓN IMPUESTO REGIMEN SIMPLE ==

{{dolist>".$misprogramas."51_regimen_simple:".$codigo."?registro=ID&status=DONE}}

== IMPUESTO A LAS GANANCIAS E IMPUESTO DIFERIDO ==

{{dolist>".$misprogramas."35_impuestos_ganancias:".$codigo."?registro=ID&status=DONE}}

== INGRESOS OPERACIONALES ==

{{dolist>".$misprogramas."36_ingresos_operacionales:".$codigo."?registro=ID&status=DONE}}

== CONTINGENCIAS NO CUANTIFICABLES Y COMPROMISOS ==

{{dolist>".$misprogramas."37_contingencias:".$codigo."?registro=ID&status=DONE}}

== PATRIMONIO ==

{{dolist>".$misprogramas."38_patrimonio:".$codigo."?registro=ID&status=DONE}}

== GASTOS OPERACIONALES ==

{{dolist>".$misprogramas."39_gastos_operacionales:".$codigo."?registro=ID&status=DONE}}

== COSTOS DE VENTAS ==

{{dolist>".$misprogramas."40_costo_ventas:".$codigo."?registro=ID&status=DONE}}

== PROPIEDAD PLANTA Y EQUIPO ==

{{dolist>".$misprogramas."41_propiedad:".$codigo."?registro=ID&status=DONE}}

== ESTIMACIONES CONTABLES ==

{{dolist>".$misprogramas."43_estimaciones:".$codigo."?registro=ID&status=DONE}}

== GASTOS DE PERSONAL ==

{{dolist>".$misprogramas."44_gastos_personales:".$codigo."?registro=ID&status=DONE}}

== INVENTARIOS ==

{{dolist>".$misprogramas."45_inventarios:".$codigo."?registro=ID&status=DONE}}

== OTROS ASUNTOS ==

{{dolist>".$misprogramas."46_otros_asuntos:".$codigo."?registro=ID&status=DONE}}


== PROGRAMA DE AUDITORÍA BONOS DE RIESGO (CHECK LISK) ==

{{dolist>".$misprogramas."bonos:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA DE AUDITORÍA BANCOS (CHECK LISK) ==

{{dolist>".$misprogramas."bancos:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA DE INVERSIONES (CHECK LISK) ==

{{dolist>".$misprogramas."inversiones:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA REVISIÓN NORMAS LEGALES (CHECK LISK) ==

{{dolist>".$misprogramas."normatividad:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA DE IMPUESTO AL PATRIMONIO (CHECK LISK) ==

{{dolist>".$misprogramas."impuesto_al_patrimonio:".$codigo."?registro=ID&status=DONE}}


== PROGRAMA DE AUDITORÍA PARA EMPRESAS EN REESTRUCTURACIÓN (CHECK LISK) ==

{{dolist>".$misprogramas."reestructuracion:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA DE AUDITORÍA PATRIMONIO (CHECK LISK) ==

{{dolist>".$misprogramas."patrimonio:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA DE AUDITORÍA DE CIERRE - MODELO 1 (CHECK LISK)  ==

{{dolist>".$misprogramas."auditoria_de_cierre:".$codigo."?registro=ID&status=DONE}}

== PROGRAMA DE AUDITORÍA DE CIERRE - MODELO 2 (CHECK LISK) ==

{{dolist>".$misprogramas."auditoria_de_cierre2:".$codigo."?registro=ID&status=DONE}}



</WRAP>

~~CLOSETOC~~

";


$diagnostico= $parte1.$parte2."===== 1. INVESTIGACIÓN Y DIAGNÓSTICO DEL CLIENTE NUEVO =====

<WRAP center round box 100%>

^REQUISITO: 1.1|<do 2023-12-31 diagnostico > Diagnóstico preliminar de clientes nuevos.</do>|
| ::: |{{:compartidos:formato_7_-_consideracion_de_integridad.xlsx|FORMATO 7 - CONSIDERACIÓN DE INTEGRIDAD}} |
^REQUISITO: 1.2|<do 2023-12-31 diagnostico > Soportes de búsqueda de enlaces listas restrictivas relacionados al final de la tabla.</do>|
| ::: |[[:comercial:gestion_comercial#busqueda_en_listas_restrictivas|LISTAS RESTRICTIVAS]]|
^REQUISITO: 1.3|<do 2023-12-31 diagnostico > Evaluación de competencias de responsables de encargos.</do>|
| ::: |{{:compartidos:formato_8_-_evaluacion_de_competencias.xlsx|FORMATO 8 - EVALUACIÓN DE COMPETENCIAS}} |
^REQUISITO: 1.4|<do 2023-12-31 diagnostico > Evaluación reputacional del cliente.</do>|
| ::: |{{:compartidos:formato_11_-_aceptacion_o_continuidad_del_encargo.xlsx|FORMATO 11 - ANALISIS DE LA REPUTACIÓN DEL CLIENTE}} |".$parte3;


$personal =$parte1.$parte2."===== 3. SELECCIONAR EL PERSONAL =====

<WRAP center round box 100%>

^REQUISITO: 3.1|<do 2023-12-31 personal > Constancia de independencia de la firma.</do>|
| ::: |{{:compartidos:formato_27_-_delaracion_independencia_de_la_firma_al_cliente.docx|FORMATO 27 - DECLARACIÓN DE INDEPENDENCIA DE LA FIRMA }} |
^REQUISITO: 3.2|<do 2023-12-31 personal > Constancia de no conflicto de intereses o independencia de los auditores y personal asignado.</do>|
| ::: |{{:compartidos:formato_22_-_no_conflicto_de_intereses_.docx|Formato 22 - INDEPENDENCIA Y NO CONFLICTO DE INTERESES DEL PERSONAL}} |".$parte3;

$personalPei= $parte1.$parte2."===== 3. SELECCIONAR EL PERSONAL =====

<WRAP center round box 100%>

^REQUISITO: 3.1|<do 2023-12-31 personal > Constancia de no conflicto de intereses o independencia de los auditores y personal asignado.</do>|
| ::: |{{:compartidos:formato_22_-_no_conflicto_de_intereses_.docx|Formato 22 - INDEPENDENCIA Y NO CONFLICTO DE INTERESES DEL PERSONAL}} |".$parte3;

//SEPARACION ENTRE OUTSOURCING DE AUDITORIA

if ($proyecto== "A" OR $proyecto== "B" OR $proyecto== "C" OR $proyecto== "D" OR $proyecto== "E" OR $proyecto== "F" OR $proyecto== "G" OR $proyecto== "H" ) {
   



$diagnosticoR= $parte1.$parte2."===== 1. INVESTIGACIÓN Y DIAGNÓSTICO DEL CLIENTE NUEVO =====

<WRAP center round box 100%>




^REQUISITO: 1.1|<do 2023-12-31 diagnostico > Diagnóstico preliminar de clientes recurrentes.</do>|
| ::: |{{ :compartidos:10:formato_26_-_diagnosticos_clientes_recurrentes.docx |FORMATO 26 - DIAGNÓSTICO CLIENTES RECURRENTES }} |
^REQUISITO: 1.2|<do 2023-12-31 diagnostico > Soportes de búsqueda de enlaces listas restrictivas relacionados al final de la tabla.</do>|
| ::: |[[:comercial:gestion_comercial#busqueda_en_listas_restrictivas|LISTAS RESTRICTIVAS]]|".$parte3;

$cliente= $parte1.$parte2."===== 2. SELECCIÓN Y ACEPTACIÓN DEL CLIENTE =====

<WRAP center round box 100%>

^REQUISITO: 2.1|<do 2023-12-31 cliente > Propuesta y el contrato.</do>|
| ::: |{{:operativo:modelo_contrato_auditoria.docx|OPE P01 F2 MODELO CONTRATO DE AUDITORÍA}} |
^REQUISITO: 2.2|<do 2023-12-31 cliente > Formalización del acuerdo de confidencialidad entre la firma y el cliente.</do>|
| ::: |{{:compartidos:formato_24_-_-acuerdo_de_confidencialidad_encargos.docx|FORMATO 24 - ACUERDO DE CONFIDENCIALIDAD ENTRE LA FIRMA Y EL CLIENTE}} |
^REQUISITO: 2.3|<do 2023-12-31 cliente > Notificación a los cliente de aceptación de encargos.</do>|
| ::: |{{:compartidos:formato_10_-_notificacion_al_cliente_aceptacion_del_encargo.docx|FORMATO 10 - NOTIFICACIÓN AL CLIENTE DE LA ACEPTACIÓN DEL ENCARGO}} |


".$parte3;

$clienteR= $parte1.$parte2."===== 2. SELECCIÓN Y ACEPTACIÓN DEL CLIENTE =====

<WRAP center round box 100%>


^REQUISITO: 2.1|<do 2023-12-31 cliente > Notificación a los cliente de aceptación de encargos.</do>|
| ::: |{{:compartidos:10:formato_10_-_notificacion_al_cliente_aceptacion_del_encargo.docx|FORMATO 10 - NOTIFICACIÓN AL CLIENTE DE LA ACEPTACIÓN DEL ENCARGO}} |".$parte3;



$riesgos =$parte1.$parte2."===== 4. ANALISIS DE RIESGOS - COMPRENSIÓN DE LA ENTIDAD =====

<WRAP center round box 100%>

^REQUISITO: 4.1|<do 2023-12-31 riesgos > Realizar el análisis de amenazas identificadas en el código de ética y los riesgos de error material.</do>|
| ::: |{{ :compartidos:formato_de_analisis_de_riesgos_operativos.xlsx |FORMATO DE ANÁLISIS DE AMENAZAS Y RIESGOS}}|".$parte3;



$materialidad = $parte1.$parte2."===== 5. CÁLCULO DE MATERIALIDAD =====


<WRAP center round box 100%>

^REQUISITO: 5.1|<do 2023-12-31 materialidad > Realizar el Cálculo de materialidad del encargo.</do>|
| ::: |{{:operativo:ope_p01_f24_calculo_de_la_materialidad.xlsx|OPE P01 F24 CÁLCULO DE MATERIALIDAD }} |".$parte3;


$materialidad_Nagas = $parte1.$parte2."===== 5. CÁLCULO DE MATERIALIDAD =====


<WRAP center round box 100%>

^REQUISITO: 5.1|<do 2023-12-31 materialidad > Realizar el Cálculo de materialidad del encargo.</do>|
| ::: |{{:operativo:ope_p01_f24b_calculo_de_la_materialidad.xlsx|OPE P01 F24 CÁLCULO DE MATERIALIDAD }} |".$parte3;



$planeacion = $parte1.$parte2."===== 6. PLANEACIÓN DEL PROYECTO =====

<wrap lo>
Con el propósito de organizar y dirigir el trabajo del revisor fiscal, se realiza el siguiente plan general de gestión. En este documento se listan todas las actividades según las funciones del revisor fiscal, los objetivos previstos y las actividades registradas en los puntos anteriores. Adicionalmente, se incluye el periodo determinado de su ejecución.

Para su cumplimiento se puede hacer uso de los modelos disponibles en la barra de botones con los siguientes modelos:
</wrap>

  * PLAN DE GESTIÓN GENERAL
  * PLAN CON PROGRAMACIÓN DE IVA BIMESTRAL
  * PLAN CON PROGRAMACIÓN DE IVA CUATRIMESTRAL
  * PLAN CON PROGRAMACIÓN RETENCIÓN EN LA FUENTE

<wrap lo>
En caso que los modelos anteriores no aseguren los requerimientos del proyecto, se adelanta la planeación mediante el uso del modelo Microsoft Excel (FORMATO OPE P01 F130 - PLANEACIÓN DE AUDITORÍAS) presentado a continuación:  
  
  
</wrap>

<WRAP center round box 100%>

^REQUISITO: 6.1|<do 2023-12-31 personal > Modelo de planeacion .</do>|
| ::: |{{:operativo:ope_p01_f130_planeacion_de_auditoria.xlsx|FORMATO OPE P01 F130 - PLANEACIÓN DE AUDITORÍAS}} |".$parte3;


$control_interno = $parte1.$parte2."===== 7. CONTROL INTERNO =====

<WRAP center round box 100%>

^REQUISITO: 7.1|<do 2023-12-31 control_interno > Realizar la evaluación del sistema de control interno.</do>|
| ::: |{{:operativo:ope_p1_f28_evaluacion_de_control_interno.xlsx |OPE P01 F28 EVALUACIÓN DE CONTROL INTERNO}} |".$parte3;


$manifestaciones =$parte1.$parte2."===== 8. CARTA DE MANIFESTACIONES - NIA 580 =====


<WRAP center round box 100%>

^REQUISITO: 9.1|<do 2023-12-31 manifestaciones > La Norma Internacional de Auditoría (NIA 580) trata de la responsabilidad en una auditoría de estados financieros de obtener manifestaciones escritas de la dirección y, cuando proceda, de los responsables del gobierno de la entidad.</do>|
| ::: |{{:operativo:ope_p01_f21_manisfestaciones-de-la-gerencia.docx|FORMATO OPE P01 F21 - CARTA DE MANIFESTACIONES}} |".$parte3;



$dictamen = $parte1.$parte2."===== 9. DICTAMEN FINAL =====


<WRAP center round box 100%>

^REQUISITO: 10.1|<do 2023-12-31 dictamen > Dictamen y evaluación de los estados contables y al sistema de control interno contable.</do>|
| ::: |{{:operativo:ope_p01_f128_dictamen_final_nias.docx|FORMATO OPE P01 F128 - DICTAMEN FINAL - NIAS}} |".$parte3;


$dictamen_Nagas = $parte1.$parte2."===== 8. DICTAMEN FINAL =====


<WRAP center round box 100%>

^REQUISITO: 9.1|<do 2023-12-31 dictamen > Dictamen y evaluación de los estados contables y al sistema de control interno contable.</do>|
| ::: |{{:operativo:ope_p01_f129_dictamen_final_nagas.docx|FORMATO OPE P01 F129 - DICTAMEN FINAL - NAGAS}} |".$parte3;


$otros= $parte1.$parte2."=== 11. OTROS REGISTROS DE GESTIÓN DE AUDITORÍA ===

<WRAP center round box 100%>

^REQUISITO: 12.1|<do 2023-12-31 otros > Diagnóstico preliminar de clientes nuevos.</do>|
| ::: |{{:operativo:formato_25-estado_situacion_financiera.xlsx|OPE P01 F25 ESTADO DE SITUACIÓN FINANCIERA}} |
^REQUISITO: 12.2|<do 2023-12-31 otros > Soportes de búsqueda de enlaces listas restrictivas relacionados al final de la tabla.</do>|
| ::: |{{:operativo:formato_26-estado_resultados_integral.xlsx|OPE P01 F26 ESTADO DE RESULTADOS DE INTEGRAL}}|
^REQUISITO: 12.3|<do 2023-12-31 otros > Evaluación de competencias de responsables de encargos.</do>|
| ::: |{{:operativo:formato_27-definicion_areas_criticas_riesgos.xlsx|OPE P01 F27 ÁREAS CRITICAS DE RIESGO}} |".$parte3;


$otros_Nagas= $parte1.$parte2."=== 10. OTROS REGISTROS DE GESTIÓN DE AUDITORÍA ===

<WRAP center round box 100%>

^REQUISITO: 11.1|<do 2023-12-31 otros > Diagnóstico preliminar de clientes nuevos.</do>|
| ::: |{{:operativo:formato_25-estado_situacion_financiera.xlsx|OPE P01 F25 ESTADO DE SITUACIÓN FINANCIERA}} |
^REQUISITO: 11.2|<do 2023-12-31 otros > Soportes de búsqueda de enlaces listas restrictivas relacionados al final de la tabla.</do>|
| ::: |{{:operativo:formato_26-estado_resultados_integral.xlsx|OPE P01 F26 ESTADO DE RESULTADOS DE INTEGRAL}}|
^REQUISITO: 11.3|<do 2023-12-31 otros > Evaluación de competencias de responsables de encargos.</do>|
| ::: |{{:operativo:formato_27-definicion_areas_criticas_riesgos.xlsx|OPE P01 F27 ÁREAS CRITICAS DE RIESGO}} |".$parte3;

//VARIABLES PARA CREAR CONSOLIDADOS

if($proyecto=="A"){
$con1="{{dolist>:proyectos:control:".$codigo.":1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":7_control_interno?control_interno=ID}}";
$con9="{{dolist>:proyectos:control:".$codigo.":9_manifestaciones?manifestaciones=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":10_dictamen?dictamen=ID}}";
 }
if($proyecto=="B"){
$con1="{{dolist>:proyectos:control:".$codigo.":recurrente:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":recurrente:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":recurrente:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":recurrente:4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":recurrente:5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":recurrente:6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":recurrente:7_control_interno?control_interno=ID}}";
$con9="{{dolist>:proyectos:control:".$codigo.":recurrente:9_manifestaciones?manifestaciones=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":recurrente:10_dictamen?dictamen=ID}}";
 }
if($proyecto=="C"){
$con1="{{dolist>:proyectos:control:".$codigo.":1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":7_control_interno?control_interno=ÏD}}";
$con10="{{dolist>:proyectos:control:".$codigo.":10_dictamen?dictamen=ID}}";
 }
 if($proyecto=="D"){
$con1="{{dolist>:proyectos:control:".$codigo.":recurrente:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":recurrente:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":recurrente:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":recurrente:4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":recurrente:5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":recurrente:6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":recurrente:7_control_interno?control_interno=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":recurrente:10_dictamen?dictamen=ID}}";
 }
if($proyecto=="E"){
$con1="{{dolist>:proyectos:control:".$codigo.":pei:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":pei:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":pei:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":pei:4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":pei:5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":pei:6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":pei:7_control_interno?control_interno=ID}}";
$con9="{{dolist>:proyectos:control:".$codigo.":pei:9_manifestaciones?manifestaciones=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":pei:10_dictamen?dictamen=ID}}";
 }
if($proyecto=="F"){
$con1="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:7_control_interno?control_interno=ID}}";
$con9="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:9_manifestaciones?manifestaciones=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:10_dictamen?dictamen=ID}}";
 }
 if($proyecto=="G"){
$con2="{{dolist>:proyectos:control:".$codigo.":pei:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":pei:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":pei:4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":pei:5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":pei:6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":pei:7_control_interno?control_interno=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":pei:10_dictamen?dictamen=ID}}";
 }
  if($proyecto=="H"){
$con1="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:4_riesgos?riesgos=ID}}";
$con5="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:5_materialidad?materialidad=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:6_planeacion?planeacion=ID}}";
$con7="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:7_control_interno?control_interno=ID}}";
$con10="{{dolist>:proyectos:control:".$codigo.":pei:recurrente:10_dictamen?dictamen=ID}}";
 }

$manifestaciones1 ="

<WRAP center round box 100%>


=== 8. CARTA DE MANIFESTACIONES - NIA 580  ===

".$con9."


</WRAP>


";
$dictamen1 ="

<WRAP center round box 100%>


=== 9. DICTAMEN FINAL ===

".$con10."


</WRAP>


";
// ELIMINA EN NAGAS LAS MANIFESTACIONES Y SE CAMBIAN LA NUMERACION

$manifestaciones1 ="
";
$dictamen1 ="
<WRAP center round box 100%>

=== 8. DICTAMEN FINAL ===

".$con10."


</WRAP>



";
$programas1 ="

<WRAP center round box 100%>


=== 9. CONSOLIDADO DE REGISTROS DE PROGRAMAS DE AUDITORÍA ===



";

$consolidado =$parte1.$parte2."

<WRAP center round box 100%>


===1. DIAGNÓSTICO INICIAL===

".$con1."

</WRAP>

<WRAP center round box 100%>


=== 2. SELECCIÓN Y ACEPTACIÓN DEL CLIENTE ===

".$con2."


</WRAP>


<WRAP center round box 100%>


=== 3. SELECCIONAR EL PERSONAL ===

".$con3."


</WRAP>


<WRAP center round box 100%>


=== 4. ANALISIS DE RIESGOS - COMPRENSIÓN DE LA ENTIDAD ===


".$con4."


</WRAP>


<WRAP center round box 100%>


=== 5. CÁLCULO DE MATERIALIDAD ===


".$con5."


</WRAP>

<WRAP center round box 100%>


=== 6. PLANEACIÓN DEL PROYECTO ===

".$con6."


</WRAP>


<WRAP center round box 100%>


=== 7. CONTROL INTERNO ===

".$con7."


</WRAP>


".$manifestaciones1.$dictamen1.$programas1.$programas2;

//notas A NIAS -CLIENTE NUEVO
   if ($proyecto=="A"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
    $carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $cliente,
    $micarpeta."/3_personal/registro.txt"=> $personal,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestaciones,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros);
}
//notas B -NIAS -CLIENTE RECURRENTE 
if ($proyecto=="B"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnosticoR,
    $micarpeta."/2_cliente/registro.txt"=> $clienteR,
    $micarpeta."/3_personal/registro.txt"=> $personal,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestaciones,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros);
}
//notas C - NAGAS -CLIENTE NUEVO
if ($proyecto=="C"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $cliente,
    $micarpeta."/3_personal/registro.txt"=> $personal,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad_Nagas,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestacionesNagas,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen_Nagas,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros_Nagas);
}
//notas D - NAGAS CLIENTE RECURRENTE
if ($proyecto=="D"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $cliente,
    $micarpeta."/3_personal/registro.txt"=> $personal,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad_Nagas,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestacionesNagas,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen_Nagas,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros_Nagas);
}
//notas E PEI NIAS -CLIENTE NUEVO
if ($proyecto=="E"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $cliente,
    $micarpeta."/3_personal/registro.txt"=> $personalPei,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestaciones,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamenNagas,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otrosNagas);
}
//notas F -NIAS -CLIENTE RECURRENTE  PEI
if ($proyecto=="F"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnosticoR,
    $micarpeta."/2_cliente/registro.txt"=> $clienteR,
    $micarpeta."/3_personal/registro.txt"=> $personalPei,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestaciones,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros);
}
//notas G - PEI NAGAS -CLIENTE NUEVO
if ($proyecto=="G"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $cliente,
    $micarpeta."/3_personal/registro.txt"=> $personalPei,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad_Nagas,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestaciones_Nagas,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen_Nagas,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros);
}
//notas H - PEI NAGAS CLIENTE RECURRENTE
if ($proyecto=="H"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_riesgos",
        $micarpeta."/5_materialidad",
        $micarpeta."/6_planeacion",
        $micarpeta."/7_control_interno",
        $micarpeta."/9_manifestaciones",
        $micarpeta."/10_dictamen",
        $micarpeta."/11_consolidado/",
        $micarpeta."/12_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $cliente,
    $micarpeta."/3_personal/registro.txt"=> $personalPei,
    $micarpeta."/4_riesgos/registro.txt"=> $riesgos,
    $micarpeta."/5_materialidad/registro.txt"=> $materialidad_Nagas,
    $micarpeta."/6_planeacion/registro.txt"=> $planeacion,
    $micarpeta."/7_control_interno/registro.txt"=> $control_interno,
    $micarpeta."/9_manifestaciones/registro.txt"=> $manifestacionesNagas,
    $micarpeta."/10_dictamen/registro.txt"=> $dictamen_Nagas,
    $micarpeta."/11_consolidado/registro.txt"=> $consolidado,
    $micarpeta."/12_otros/registro.txt"=> $otros_Nagas);
}

}
//CIERRA IF DE SEPARACION
// GENERA EL CODIGO DE OUTSOURCING Y OTROS SERVICIOS

//SEPARACION ENTRE OUTSOURCING DE AUDITORIA

if ($proyecto== "I" OR $proyecto== "J" OR $proyecto== "K" OR $proyecto== "L" OR $proyecto== "M" OR $proyecto== "N") {


   if($proyecto=="I"){
$con1="{{dolist>:proyectos:control:".$codigo.":outsourcing:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":outsourcing:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":outsourcing:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":outsourcing:4_planeacion?planeacion=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":outsourcing:6_infomes?informes=ID}}";
 }
    if($proyecto=="J"){
$con1="{{dolist>:proyectos:control:".$codigo.":asesoria:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":asesoria:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":asesoria:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":asesoria:4_planeacion?planeacion=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":asesoria:6_infomes?informes=ID}}";
 }
     if($proyecto=="K"){
$con1="{{dolist>:proyectos:control:".$codigo.":otros:1_planeacion?planeacion=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":otros:2_operacion?operaciones=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":otros:6_infomes?informes=ID}}";
 }
    if($proyecto=="M"){
$con1="{{dolist>:proyectos:control:".$codigo.":outsourcing:pei:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":outsourcing:pei:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":outsourcing:pei:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":outsourcing:pei:4_planeacion?planeacion=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":outsourcing:pei:6_infomes?informes=ID}}";
 }
     if($proyecto=="N"){
$con1="{{dolist>:proyectos:control:".$codigo.":asesoria:pei:1_diagnostico?diagnostico=ID}}";
$con2="{{dolist>:proyectos:control:".$codigo.":asesoria:pei:2_cliente?cliente=ID}}";
$con3="{{dolist>:proyectos:control:".$codigo.":asesoria:pei:3_personal?personal=ID}}";
$con4="{{dolist>:proyectos:control:".$codigo.":asesoria:pei:4_planeacion?planeacion=ID}}";
$con6="{{dolist>:proyectos:control:".$codigo.":asesoria:pei:6_infomes?informes=ID}}";
 }



$clienteOut= $parte1.$parte2."===== 2. SELECCIÓN Y ACEPTACIÓN DEL CLIENTE =====

<WRAP center round box 100%>



^REQUISITO: 2.1|<do 2023-12-31 cliente > Propuesta y el contrato.</do>|
| ::: |{{:operativo:modelo_contrato_asesoria_contable.docx|2. OPE P01 F28 Modelo contrato de asesoría contable}}  |
^REQUISITO: 2.2|<do 2023-12-31 cliente > Formalización del acuerdo de confidencialidad entre la firma y el cliente.</do>|
| ::: |{{:compartidos:formato_24_-_-acuerdo_de_confidencialidad_encargos.docx|FORMATO 24 - ACUERDO DE CONFIDENCIALIDAD ENTRE LA FIRMA Y EL CLIENTE}} |


".$parte3;


$planeacionOut = $parte1.$parte2."===== 4. PLANEACIÓN DEL PROYECTO =====

<wrap lo>
Con el propósito de organizar y dirigir el trabajo del revisor fiscal, se realiza el siguiente plan general de gestión. En este documento se listan todas las actividades según las funciones del contador asignado, los objetivos previstos y las actividades registradas en los puntos anteriores. Adicionalmente, se incluye el periodo determinado de su ejecución.

</wrap>



<WRAP center round box 100%>

^REQUISITO: 6.1|<do 2023-12-31 documentos > El socio director, teniendo en cuenta el tamaño, objeto social, responsabilidad que se debe asumir y los compromisos adquiridos con el cliente deben analizar y definir el equipo de trabajo para cada encargo y efectuar la presentación del equipo de trabajo al cliente mediante correo electrónico.</do>|
| ::: |{{:operativo:ope_p04_f1_check_documentos_legales_y_fiscales.docx|OPE P02 F1 CHECK LIST DOCUMENTOS LEGALES Y FISCALES}} |


{{filelisting>...:}}

</WRAP>


----



<WRAP center round box 100%>

^REQUISITO: 6.2|<do 2023-12-31 cronograma > El primer día hábil de cada mes, todos los miembros del equipo, deben realizar un cronograma de trabajo por cliente y archivarlo en la carpeta compartida de trabajo.</do>|
| ::: |{{:operativo:ope_p04_f2_cronograma_de_trabajo.xlsx|OPE P02 F2 CRONOGRAMA DE TRABAJO}} |


{{filelisting>...:}}

</WRAP>


----


<WRAP center round box 100%>

^REQUISITO: 6.3|<do 2023-12-31 impuestos >El Coordinador debe enviar la documentación (Estados Financieros de presentación, memorando de recomendaciones, papeles de trabajo) al Socio director para su respectiva revisión. Si el Socio director identifica un error, debe notificar al Coordinador mediante correo electrónico, con copia a Socio director y devolver los documentos para su respectiva corrección. En caso contrario, notifica al Coordinador, mediante correo electrónico, sobre su aprobación para enviar los documentos al cliente.</do>|
| ::: |{{:operativo:ope_p04_f3_control_de_vencimiento_de_impuestos.xlsx|OPE P02 F3 CONTROL DE VENCIMIENTO DE IMPUESTOS}} |


{{filelisting>...:}}

</WRAP>


----


<WRAP center round box 100%>

^REQUISITO: 6.4|<do 2023-12-31 cierre >
La labor del Coordinador finaliza cuando realiza la entrega de todos los documentos soporte en físico, generados durante el desarrollo de la Consultoría, al Socio director para su respectivo archivo en la carpeta de cada cliente. Labor que debe realizarse de manera mensual (a final de mes), garantizando la oportunidad de su archivo y control documental. Los documentos digitales, a cargo del Coordinador, deben ser archivados en la carpeta operativa de cada cliente de la carpeta compartida de la firma.</do>|
| ::: |{{:operativo:ope_p04_f4_check_list_cierre_de_ano.docx|OPE P02 F4 CHECK LIST CIERRE DE AÑO}} |".$parte3;


$informesOut = $parte1.$parte2."===== 6. INFORMES =====

<WRAP center round box 100%>

<wrap lo>
El objetivo de los informes técnicos es presentar de forma clara y detallada el trabajo técnico y el estado  de situación, para la toma de decisiones respecto de la situación que se describe en sus contenidos: 
</wrap>

".$parte3;

$otrosOut= $parte1.$parte2."=== 7. OTROS REGISTROS  ===


<WRAP center round box 100%>


".$parte3;



$consolidadoOut =$parte1.$parte2."

<WRAP center round box 100%>


===1. DIAGNÓSTICO INICIAL===

".$con1."

</WRAP>

<WRAP center round box 100%>


=== 2. SELECCIÓN Y ACEPTACIÓN DEL CLIENTE ===

".$con2."


</WRAP>


<WRAP center round box 100%>


=== 3. SELECCIONAR EL PERSONAL ===

".$con3."


</WRAP>


<WRAP center round box 100%>


=== 4. PLANEACIÓN ===


".$con4."


</WRAP>


<WRAP center round box 100%>


=== 5. INFORMES ===


".$con6."


</WRAP>

".$programas1.$programas2;


//notas I - OUTSOURCING
if ($proyecto=="I" ){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_planeacion",
        $micarpeta."/6_informes",
        $micarpeta."/7_consolidado/",
        $micarpeta."/8_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $clienteOut,
    $micarpeta."/3_personal/registro.txt"=> $personal,
    $micarpeta."/4_planeacion/registro.txt"=> $planeacionOut,
    $micarpeta."/6_informes/registro.txt"=> $informesOut,
    $micarpeta."/7_consolidado/registro.txt"=> $consolidadoOut,
    $micarpeta."/8_otros/registro.txt"=> $otrosOut);
}
if ($proyecto=="J"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_planeacion",
        $micarpeta."/6_informes",
        $micarpeta."/7_consolidado/",
        $micarpeta."/8_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $clienteOut,
    $micarpeta."/3_personal/registro.txt"=> $personal,
    $micarpeta."/4_planeacion/registro.txt"=> $planeacionOut,
    $micarpeta."/6_informes/registro.txt"=> $informesOut,
    $micarpeta."/7_consolidado/registro.txt"=> $consolidadoOut,
    $micarpeta."/8_otros/registro.txt"=> $otrosOut);
}

if ($proyecto=="K"){
        $sitios= array(
        $micarpeta."/1_planeacion",
        $micarpeta."/2_informes");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_planeacion/registro.txt"=> $planeacionOut,
    $micarpeta."/2_informes/registro.txt"=> $informesOut);
}
if ($proyecto=="M"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_planeacion",
        $micarpeta."/6_informes",
        $micarpeta."/7_consolidado/",
        $micarpeta."/8_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $clienteOut,
    $micarpeta."/3_personal/registro.txt"=> $personalPei,
    $micarpeta."/4_planeacion/registro.txt"=> $planeacionOut,
    $micarpeta."/6_informes/registro.txt"=> $informesOut,
    $micarpeta."/7_consolidado/registro.txt"=> $consolidadoOut,
    $micarpeta."/8_otros/registro.txt"=> $otrosOut);
}
if ($proyecto=="N"){
        $sitios= array(
        $micarpeta."/1_diagnostico",
        $micarpeta."/2_cliente",
        $micarpeta."/3_personal",
        $micarpeta."/4_planeacion",
        $micarpeta."/6_informes",
        $micarpeta."/7_consolidado/",
        $micarpeta."/8_otros/");
        foreach ($sitios as $key => $value) {
            mkdir($value, 0755, true);
                        }
$carpetas= array(
    $micarpeta."/1_diagnostico/registro.txt"=> $diagnostico,
    $micarpeta."/2_cliente/registro.txt"=> $clienteOut,
    $micarpeta."/3_personal/registro.txt"=> $personalPei,
    $micarpeta."/4_planeacion/registro.txt"=> $planeacionOut,
    $micarpeta."/6_informes/registro.txt"=> $informesOut,
    $micarpeta."/7_consolidado/registro.txt"=> $consolidadoOut,
    $micarpeta."/8_otros/registro.txt"=> $otrosOut);
}

}

//echo var_dump($carpetas);
/// creacion de archivos
foreach ($carpetas as $destino => $value) {
$archivo= fopen($destino, 'a+');
fwrite($archivo, $value);
fclose($archivo);
}
}

?>


</div>

</body>
</html>

